/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import net.adventurez.entity.ShamanEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class SpellCastingEntity
extends Monster {
    private static final EntityDataAccessor<Byte> SPELL = SynchedEntityData.m_135353_(SpellCastingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected int spellTicks;
    private Spell spell = Spell.NONE;

    public SpellCastingEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL, (Object)0);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.spellTicks = tag.m_128451_("SpellTicks");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("SpellTicks", this.spellTicks);
    }

    public boolean isSpellcasting() {
        if (this.m_9236_().m_5776_()) {
            return (Byte)this.f_19804_.m_135370_(SPELL) > 0;
        }
        return this.spellTicks > 0;
    }

    public void setSpell(Spell spell) {
        this.spell = spell;
        this.f_19804_.m_135381_(SPELL, (Object)((byte)spell.id));
    }

    protected Spell getSpell() {
        return !this.m_9236_().m_5776_() ? this.spell : Spell.byId(((Byte)this.f_19804_.m_135370_(SPELL)).byteValue());
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_() && this.isSpellcasting() && !(this instanceof ShamanEntity)) {
            Spell spell = this.getSpell();
            double d = spell.particleVelocity[0];
            double e = spell.particleVelocity[1];
            double f = spell.particleVelocity[2];
            float g = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float h = Mth.m_14089_((float)g);
            float i = Mth.m_14031_((float)g);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)h * 0.92, this.m_20186_() + 2.32, this.m_20189_() + (double)i * 0.92, d, e, f);
        }
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected abstract SoundEvent getCastSpellSound();

    public static enum Spell {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_PUPPET(1, 0.01, 0.01, 0.015),
        WITHERING(2, 0.01, 0.01, 0.015),
        SHIELD(3, 0.01, 0.01, 0.01),
        TELEPORT(4, 0.005, 0.005, 0.015),
        THUNDERBOLT(5, 0.015, 0.015, 0.015);

        private final int id;
        private final double[] particleVelocity;

        private Spell(int id, double particleVelocityX, double particleVelocityY, double particleVelocityZ) {
            this.id = id;
            this.particleVelocity = new double[]{particleVelocityX, particleVelocityY, particleVelocityZ};
        }

        public static Spell byId(int id) {
            for (Spell spell : Spell.values()) {
                if (id != spell.id) continue;
                return spell;
            }
            return NONE;
        }
    }

    public class LookAtTargetGoal
    extends Goal {
        public LookAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SpellCastingEntity.this.getSpellTicks() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            SpellCastingEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            SpellCastingEntity.this.setSpell(Spell.NONE);
        }

        public void m_8037_() {
            if (SpellCastingEntity.this.m_5448_() != null) {
                SpellCastingEntity.this.m_21563_().m_24960_((Entity)SpellCastingEntity.this.m_5448_(), (float)SpellCastingEntity.this.m_8085_(), (float)SpellCastingEntity.this.m_8132_());
            }
        }
    }

    public abstract class CastSpellGoal
    extends Goal {
        protected int spellCooldown;
        protected int startTime;

        protected CastSpellGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = SpellCastingEntity.this.m_5448_();
            if (livingEntity != null && livingEntity.m_6084_()) {
                if (SpellCastingEntity.this.isSpellcasting()) {
                    return false;
                }
                return SpellCastingEntity.this.f_19797_ >= this.startTime;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = SpellCastingEntity.this.m_5448_();
            return livingEntity != null && livingEntity.m_6084_() && this.spellCooldown > 0;
        }

        public void m_8056_() {
            this.spellCooldown = this.getInitialCooldown();
            SpellCastingEntity.this.spellTicks = this.getSpellTicks();
            this.startTime = SpellCastingEntity.this.f_19797_ + this.startTimeDelay();
            SoundEvent soundEvent = this.getSoundPrepare();
            if (soundEvent != null) {
                SpellCastingEntity.this.m_5496_(soundEvent, 1.0f, 1.0f);
            }
            SpellCastingEntity.this.setSpell(this.getSpell());
        }

        public void m_8037_() {
            --this.spellCooldown;
            if (this.spellCooldown == 0) {
                this.castSpell();
                SpellCastingEntity.this.m_5496_(SpellCastingEntity.this.getCastSpellSound(), 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getInitialCooldown() {
            return 20;
        }

        protected abstract int getSpellTicks();

        protected abstract int startTimeDelay();

        @Nullable
        protected abstract SoundEvent getSoundPrepare();

        protected abstract Spell getSpell();
    }
}

